/*
 * Decompiled with CFR 0.152.
 */
package com.mrc.offline;

import com.google.gson.Gson;
import com.mrc.http.Util;
import com.mrc.model.MobileResources;
import com.mrc.util.MobileTemplate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class TemplateCache
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String APPCACHE_CONTENT_TYPE = "text/cache-manifest";
    private static final String LF = "\r\n";
    private static final String APPCACHE_HEADER = "CACHE MANIFEST";
    private static final String SECTION_NETWORK = "NETWORK:";
    private static final String FILE_CACHECFG_POSTFIX = ".templatemanifest";
    private static final String FILE_APPCACHE_PROPERTIES = "appcache.properties";
    private static final String KEY_FILENAME_REPLACEMENTS = "appcache.filename_replacements";
    private static final String KEY_DELAY = "appcache.refresh_delay";
    private static final long DEFAULT_REFRESH_DELAY = 5000L;
    private Map<String, String> replacementsMap;
    private Properties appcacheServletProperties;
    private Long refreshDelay;

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.log("Cache manifest requested");
        response.setContentType(APPCACHE_CONTENT_TYPE);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addDateHeader("Last-Modified", System.currentTimeMillis());
        httpResponse.addDateHeader("Expires", System.currentTimeMillis());
        httpResponse.addHeader("Pragma", "no-cache");
        int resources = Util.getRequestParam((HttpServletRequest)httpServletRequest, (String)"resources", (int)0);
        String applicationName = Util.getRequestParam((HttpServletRequest)httpServletRequest, (String)"appname", (String)"");
        String targetServletPath = httpServletRequest.getPathInfo();
        int idx = targetServletPath.lastIndexOf(47);
        String lib = "";
        if (idx != -1) {
            lib = targetServletPath.substring(idx + 1);
        }
        String jsonresponse = "";
        if (resources == 1) {
            jsonresponse = this.doResources(httpServletRequest, httpResponse, lib, applicationName);
        }
        httpResponse.setContentType("text/json");
        httpResponse.setContentLength(jsonresponse.length());
        PrintWriter writer = httpResponse.getWriter();
        writer.print(jsonresponse);
        writer.flush();
        httpResponse.flushBuffer();
    }

    public String doResources(HttpServletRequest httpServletRequest, HttpServletResponse httpResponse, String lib, String application) throws IOException {
        Object line;
        BufferedReader reader;
        String filename;
        ServletContext context = this.getServletContext();
        String manifestFilePath = context.getRealPath("appcache" + File.separator + application + ".manifest");
        File f = new File(manifestFilePath);
        MobileResources resource = new MobileResources();
        boolean isResourcesJs = false;
        boolean isResourcesCss = false;
        boolean isTemplates = false;
        boolean isData = false;
        boolean isStartPage = false;
        ArrayList<String> jsResourceList = new ArrayList<String>();
        ArrayList<String> cssResourceList = new ArrayList<String>();
        ArrayList<String> htmlResourceList = new ArrayList<String>();
        ArrayList<String> dataResourceList = new ArrayList<String>();
        String startPage = "";
        BufferedReader br = new BufferedReader(new FileReader(f));
        try {
            String line2 = null;
            while ((line2 = br.readLine()) != null) {
                if (line2.trim().isEmpty()) continue;
                if (line2.startsWith("#")) {
                    isResourcesJs = line2.startsWith("#resources-js");
                    isResourcesCss = line2.startsWith("#resources-css");
                    isTemplates = line2.startsWith("#templates");
                    isData = line2.startsWith("#data");
                    if (line2.startsWith("#start-page")) {
                        isStartPage = true;
                        continue;
                    }
                    isStartPage = false;
                    continue;
                }
                if (isResourcesJs) {
                    jsResourceList.add(line2.trim());
                }
                if (isResourcesCss) {
                    cssResourceList.add(line2.trim());
                }
                if (isTemplates) {
                    htmlResourceList.add(line2.trim());
                }
                if (isData) {
                    dataResourceList.add(line2.trim());
                }
                if (!isStartPage) continue;
                startPage = line2.trim();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        String filePath = context.getRealPath("");
        StringBuffer sb = new StringBuffer();
        for (String file : jsResourceList) {
            file = StringUtils.replace((String)file, (String)"/", (String)File.separator);
            filename = String.valueOf(filePath) + file;
            reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                sb.append((String)line);
            }
        }
        resource.setJs(sb.toString());
        sb = new StringBuffer();
        for (String file : cssResourceList) {
            file = StringUtils.replace((String)file, (String)"/", (String)File.separator);
            filename = String.valueOf(filePath) + file;
            reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                sb.append((String)line);
            }
        }
        resource.setCss(sb.toString());
        resource.setDataStores(dataResourceList);
        resource.setStartPage(startPage);
        InputStream is1 = null;
        BufferedReader br1 = null;
        HashMap<String, MobileTemplate> templateList = new HashMap<String, MobileTemplate>();
        for (String htmlFile : htmlResourceList) {
            String[] templatedata = htmlFile.split(":");
            is1 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/" + lib + "/" + templatedata[0]);
            br1 = new BufferedReader(new InputStreamReader(is1));
            boolean inBody = false;
            String line3 = null;
            sb = new StringBuffer();
            MobileTemplate mbTemp = new MobileTemplate();
            while ((line3 = br1.readLine()) != null) {
                if (line3.trim().isEmpty()) continue;
                if (line3.trim().contains("begin body")) {
                    inBody = true;
                }
                if (line3.trim().contains("end body")) {
                    inBody = false;
                }
                if (!inBody) continue;
                sb.append(line3.trim());
            }
            mbTemp.setId(templatedata[0]);
            mbTemp.setHtml(sb.toString());
            mbTemp.setDataStore(templatedata[1]);
            templateList.put(templatedata[0], mbTemp);
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException htmlFile) {
                // empty catch block
            }
        }
        resource.setMobileTemplates(templateList);
        Gson gson = new Gson();
        String jsonresponse = gson.toJson((Object)resource);
        return jsonresponse;
    }
}

