/*
2014 michaels ross and cole ltd
This demo has been adapted from code made available by FTLabs. Attribution below:
Copyright (C) 2013 The Financial Times Ltd.
*/
APP.indexedDB = (function () {
  'use strict';
 
  var db, indexedDB, IDBTransaction, IDBKeyRange;
  var version = 5;
  function indexedDBError(event) {
    if (typeof console !== "undefined") {
      console.error("An error occurred", event);
    }
  }
  function start(successCallback, failureCallback){
   // Protect ourselves inside old browsers
    try {
      indexedDB = window.indexedDB || window.webkitIndexedDB || window.mozIndexedDB || window.msIndexedDB;
      IDBTransaction = window.hasOwnProperty('webkitIndexedDB') ? window.webkitIDBTransaction : window.IDBTransaction;
      IDBKeyRange = window.hasOwnProperty('webkitIndexedDB') ? window.webkitIDBKeyRange : window.IDBKeyRange;
	
    } catch (e) {
      failureCallback();
    }
    if (!indexedDB) {
      failureCallback();
      return;
    }
	 failureCallback();
      return;
	var request = indexedDB.open("MYDB", version);
	request.onerror = failureCallback();
	request.onsuccess = function (event) {	
		db = event.target.result;
		successCallback();
		return;
	};
  }
  function install(data, successCallback, failureCallback) {
	
   
   
    var request = indexedDB.open("MYDB", version);
	
    function installModels() {
		var model = "";
		if(data === null){
			return;
		}else{
			model = data.model.model;
		}
      if (db.objectStoreNames.contains(model)) {
        db.deleteObjectStore(model);
      }
 
      // TODO This is strictly model logic, and ought not live inside the indexedDB library, should move.
	  var keys = data.model.keys;
      var store = db.createObjectStore(model, { keyPath: "mrc_id" });
	  store.createIndex('mrc_id', 'mrc_id', { unique: false });
	  for(var j in keys){
		 store.createIndex(keys[j], keys[j], { unique: false });
	  }
	  store = db.createObjectStore(model + AUDIT_TABLE_SUFFIX, { keyPath: "mrc_id" });
	  store.createIndex('mrc_id', 'mrc_id', { unique: false });
    }
 
    request.onsuccess = function (event) {
      var setVersionRequest;
 
      db = event.target.result;
      version = String(version);
      if (db.setVersion && version !== db.version) {
        setVersionRequest = db.setVersion(version);
        setVersionRequest.onfailure = indexedDBError;
        setVersionRequest.onsuccess = function (event) {
          installModels();
          setVersionRequest.result.oncomplete = function () {
            if (successCallback) {
              successCallback();
            }
          };
        };
 
      } else {
        successCallback();
      }
    };
    request.onupgradeneeded = function (event) {
      db = event.target.result;
      installModels();
    };
    request.onerror = function (event) {
      alert("You have chosen not to use offline storage");
      failureCallback();
    };
  }
  function getAuditData(model,returnDataCallback){
		var auditModel = model.model + AUDIT_TABLE_SUFFIX;
		var modelResultSet = new Array();
		var transaction = db.transaction([auditModel], IDBTransaction.READ_ONLY || 'readonly'), store, request, results = [];
		transaction.onerror = indexedDBError;
		store = transaction.objectStore(auditModel);
		request = store.openCursor();
	 
		request.onerror = returnDataCallback;
		function getDBrecords(auditResults){
			if(!auditResults){
				returnDataCallback();
				return false;
			}
			transaction = db.transaction([model.model], IDBTransaction.READ_WRITE || 'readwrite'), store, request, results = [];
			transaction.onerror = returnDataCallback;
			store = transaction.objectStore( model.model);
			function getNextRecord(idx){
				if(idx < auditResults.length){
					var id = auditResults[idx]['mrc_id'];
					var action = auditResults[idx]['ROWDATA'];
					request = store.get(id);
					request['action'] = action;
					request.onerror = indexedDBError;
					request.onsuccess = function (event) {
					  var result = event.target.result;
					  result['audit_action'] = request['action'];
					  modelResultSet.push(result);
					  getNextRecord(idx + 1);
					};
				}else{
					returnDataCallback(modelResultSet);
				}
			}
			getNextRecord(0);
				
		}
		request.onsuccess = function (event) {
		  var result = event.target.result;
	 
		  // When result is null the end is reached
		  if (!result) {
			getDBrecords(results);
			return;
		  }
		  results.push(result.value);
	 
		  // Weird to hack jslint
		  result['continue']();
		};
		
	}
	function deleteAudit(model,successCallback){
		var auditmodel = model  + AUDIT_TABLE_SUFFIX;
		var transaction = db.transaction([auditmodel], IDBTransaction.READ_WRITE || 'readwrite'), store, request, results = [];
		transaction.onerror = successCallback;
		store = transaction.objectStore( auditmodel);
		var request = store.clear();
		request.onsuccess = function(){
			successCallback();
		}
	}
  function doAudit(model,keyValue,action,successCallback){
		model = model + AUDIT_TABLE_SUFFIX;
		var transaction = db.transaction([model], IDBTransaction.READ_WRITE || 'readwrite'), store, i, request, total = 1;
		var dataObj = new Object();
		dataObj.mrc_id = keyValue;
		dataObj.ROWDATA = action;
		transaction.onerror = indexedDBError;
		store = transaction.objectStore(model);
		function successCallbackInner() {
			successCallback();
		}
		request = store.put(dataObj);
		request.onsuccess = successCallbackInner;
		request.onerror = indexedDBError;
  }
  function updateOne(dataModelObj,dbDataObj, successCallback){
		this.insertOne(dataModelObj,dbDataObj, function(keyValue){
			var model = dataModelObj.model;
			doAudit(model,keyValue,"update",successCallback);
		});
  }
  function deleteOne(dataModelObj,dbDataObj, successCallback){
  
	var model = dataModelObj.model;
	var keys = dataModelObj.keys;
	var data = dbDataObj
	 var transaction = db.transaction([model], IDBTransaction.READ_WRITE || 'readwrite'), store, i, request, total = 1;
	var keyValue = "";
	for(var j in keys){
		if(j > 0){
			keyValue += MULTI_KEY_DELIMIT;
		}
		keyValue += data[keys[j]];
	}
    function successCallbackInner() {
      total = total - 1;
      if (total === 0) {
		doAudit(model,keyValue,"delete",successCallback);
        
      }
    }
 
    transaction.onerror = indexedDBError;
    store = transaction.objectStore(model);
	
	request = store.delete(keyValue);
    request.onsuccess = successCallbackInner;
    request.onerror = indexedDBError;
 }
 function insertOne(dataModelObj,dbDataObj, successCallback){
	var model = dataModelObj.model;
	var keys = dataModelObj.keys;
	var data = dbDataObj
	 var transaction = db.transaction([model], IDBTransaction.READ_WRITE || 'readwrite'), store, i, request, total = 1;
	var keyValue = "";
	for(var j in keys){
		if(j > 0){
			keyValue += MULTI_KEY_DELIMIT;
		}
		keyValue += data[keys[j]];
	}
    function successCallbackInner() {
      total = total - 1;
      if (total === 0) {
        successCallback(keyValue);
      }
    }
 
    transaction.onerror = indexedDBError;
    store = transaction.objectStore(model);
	
	data['mrc_id'] = keyValue;
	request = store.put(data);
	request.onsuccess = successCallbackInner;
	request.onerror = indexedDBError;
 }
  function insertInto(dataObj, successCallback) {
	var model = dataObj.model.model;
	var keys = dataObj.model.keys;
	var data = dataObj.table_rows;
    var transaction = db.transaction([model], IDBTransaction.READ_WRITE || 'readwrite'), store, i, request, total = data.length;
 
    function successCallbackInner() {
      total = total - 1;
      if (total === 0) {
        successCallback();
      }
    }
 
    transaction.onerror = indexedDBError;
    store = transaction.objectStore(model);
    for (i in data) {
		var keyValue = "";
		for(var j in keys){
			if(j > 0){
				keyValue += MULTI_KEY_DELIMIT;
			}
			keyValue += data[i][keys[j]];
		}
		data[i]['mrc_id'] = keyValue;
      if (data.hasOwnProperty(i)) {
        request = store.put(data[i]);
        request.onsuccess = successCallbackInner;
        request.onerror = indexedDBError;
      }
    }
  }
 
  function deleteAllFrom(model, successCallback) {
	  try{
			var transaction = db.transaction([model], IDBTransaction.READ_WRITE || 'readwrite'), store, request;
			transaction.onerror = indexedDBError;
			store = transaction.objectStore(model);
			request = store.clear();
			request.onerror = indexedDBError;
			request.onsuccess = successCallback;
		}catch(err){
			successCallback(null);
		}
  }
 
  function selectAll(modelObj, successCallback) {
	var model = modelObj.model;
    var transaction = db.transaction([model], IDBTransaction.READ_ONLY || 'readonly'), store, request, results = [];
    transaction.onerror = indexedDBError;
    store = transaction.objectStore(model);
    request = store.openCursor();
 
    request.onerror = indexedDBError;
    request.onsuccess = function (event) {
      var result = event.target.result;
 
      // When result is null the end is reached
      if (!result) {
        successCallback(results);
        return;
      }
      results.push(result.value);
 
      // Weird to hack jslint
      result['continue']();
    };
  }
  function getMaxValue(modelObj,successCallback){
	var model = modelObj.model;
    var transaction = db.transaction([model], IDBTransaction.READ_ONLY || 'readonly'), store, request, results = [];
    transaction.onerror = indexedDBError;
    store = transaction.objectStore(model);
	var index  = store.index(modelObj.keys[0]);
    request = index.openCursor();
 
    request.onerror = indexedDBError;
	var highestValue;
    request.onsuccess = function (event) {
      var cursor = evt.target.result;
	 if (cursor) {
		highestValue = cursor.value;
		cursor.continue();
	 }else{
		successCallback(highestValue);
	 }
    };
  }
  function selectForSearch(model,selectionObj,successCallback) {
		var dataSet = new Array();
		var singleKeyRange = IDBKeyRange.only("Donna");
		 var transaction = db.transaction([model], IDBTransaction.READ_ONLY || 'readonly'), store, request, results = [];
		transaction.onerror = indexedDBError;
		function getNextIndex(idx){
			if(idx == selectionObj.whereFields.length){
				successCallback(dataSet);
			}
			var range = IDBKeyRange.only(selectionObj.whereValues[idx]);
			var store = transaction.objectStore(model);
			var index  = store.index(selectionObj.whereFields[idx]);
			index.openCursor(range).onsuccess = function(evt) {
				 var cursor = evt.target.result;
				 if (cursor) {
					dataSet.push(cursor.value)
					cursor.continue();
				 }else{
					getNextIndex(idx + 1);
				 }
			  };
		}
		getNextIndex(0);
    }
  function selectOne(model, whereFields, whereValues, successCallback) {
		var id = "";
		for(var j in whereValues){
			if(j > 0){
				id += MULTI_KEY_DELIMIT;
			}
			id += whereValues[j];
		}
		var transaction = db.transaction([model], IDBTransaction.READ_WRITE || 'readwrite'), store, request;
		transaction.onerror = indexedDBError;
		store = transaction.objectStore(model);
		request = store.get(id);
		request.onerror = indexedDBError;
		request.onsuccess = function (event) {
		  var result = event.target.result;
		  successCallback(result);
		};
  }
 
  
 
  return {
    start: start,
	install:install,
    insertInto: insertInto,
    deleteAllFrom: deleteAllFrom,
    selectAll: selectAll,
    selectOne: selectOne,
	insertOne:insertOne,
	updateOne:updateOne,
	deleteOne:deleteOne,
	doAudit:doAudit,
	selectForSearch:selectForSearch,
	getMaxValue:getMaxValue,
	getAuditData:getAuditData,
	deleteAudit:deleteAudit,
	type:'indexeddb'
  };
}());