/*
2014 michaels ross and cole ltd
This demo has been adapted from code made available by FTLabs. Attribution below:
Copyright (C) 2013 The Financial Times Ltd.
*/
var APP = {};
var TEMPLATE_KEY = "mrc-app-templates";
var MULTI_KEY_DELIMIT = "__";
var SERVLET_PATH = "/mrcjava/servlet/";
var DATA_MODEL = "mrc-data-model";
var PAGE_MODEL = "mrc-page-model";
var RESOURCES = "mrc-resources";
var APP_NAME_KEY = "mrc-session-app";
var history = new Array();
function refreshEvents(){
	setupClickListenerMobile();
}
jQuery.fn.serializeObject = function()
{
    var o = {};
    var a = this.serializeArray();
    jQuery.each(a, function() {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};
function getResources(){
	var appName = sessionStorage.getItem(APP_NAME_KEY); //get the application name saved in session at startup
	var resources = localStorage.getItem(RESOURCES + '-' + appName); //get the saved resources for this application
	resources = jQuery.parseJSON(resources);
	return resources;
}
function getModelName(resources,templateId){
	var templates = resources.mobileTemplates;
	var homeTemplateObj = templates[templateId];
	var model = homeTemplateObj.dataStore;
	model = model.replace(".","_");
	return model;
}
function getDataModel(modelName){
	var modelObj = localStorage.getItem(DATA_MODEL + '-' + modelName);
	modelObj = jQuery.parseJSON(modelObj);
	return modelObj;
}
function getDbDataObj(dataModelObj,formObj){
	var fields = dataModelObj.fields;
	var dbDataObj = new Object();
	for(var i in fields){
		dbDataObj[fields[i]] = formObj[fields[i]];
	}
	return dbDataObj;
}
function submitFormOffline(formObj){
	var templateId = formObj['pageName'];
	var resources = getResources();
	var modelName = getModelName(resources, templateId);
	var dataModelObj = getDataModel(modelName);
	var action = formObj['action_mode'];
	var keys = dataModelObj.keys;
	
	var keyValue = '';
	for(var i in keys){
		
		if(i > 0){
			keyValue += MULTI_KEY_DELIMIT;
		}
		keyValue += formObj[keys[i]];
	}
	
	
	var dbDataObj = getDbDataObj(dataModelObj,formObj);
	var redirect = formObj['mobile_redirect'];
	if(!redirect){
		redirect = "";
	}
	switch(action){
		case 'add':APP.database.insertOne(dataModelObj,dbDataObj,function(keyValue){
						var model = dataModelObj.model;
						function addCallBack(){
							var addRedirect = formObj['mobile_add_redirect'];
							redirect = getRedirect(addRedirect,redirect);
							APP.templates.showPage(resources, redirect);
						}
						if(APP.database.type == 'indexeddb'){
							APP.database.doAudit(model,keyValue,"add",function(){
								addCallBack();
								return;
							});
						}else{
							addCallBack()
						}
						
					});
			break;
		case 'update':APP.database.updateOne(dataModelObj,dbDataObj,function(results){
						var updateRedirect = formObj['mobile_update_redirect'];
						redirect = getRedirect(updateRedirect,redirect);
						APP.templates.showPage(resources, redirect);
					});
			break;
		case 'delete':APP.database.deleteOne(dataModelObj,dbDataObj,function(results){
						var deleteRedirect = formObj['mobile_delete_redirect'];
						redirect = getRedirect(deleteRedirect,redirect);
						APP.templates.showPage(resources, redirect);
					});
			break;
	}
}
function getRedirect(actionRedirect,allRedirect){
	if(actionRedirect && jQuery.trim(actionRedirect) != ''){
		return actionRedirect;
	}else{
		return allRedirect;
	}
}
jQuery(document).ready(function(){
	jQuery(".doback").live('click',function(){
		var html = history[history.length - 1];
		jQuery("body").html(html);
		history.splice((history.length - 1),1);
		refreshEvents();
	});
	jQuery("form").live('submit',function(e){
		var test = true;
		if((navigator && navigator.onLine === false)|| test == true){
			e.preventDefault();
			var formObj = jQuery(this).serializeObject();
			submitFormOffline(formObj);
			return false;
		}
	});
jQuery("a").die('click');
jQuery("a").unbind('click');
	jQuery("a.mobile-link").live('click',function(e){alert(1);
		var test = false;
		if((navigator && navigator.onLine === false)|| test == true){
			e.preventDefault();
			e.stopPropagation();
			var href= jQuery(this).attr('href');
			var templateId = jQuery(this).attr('data-offline-template');
			var templateKeyData =jQuery(this).attr('data-offline-key');
			loadLocalPage(href,templateId,templateKeyData);
			return false;
			
		}
	});
	jQuery("td.mobile-link").live('click',function(e){alert('test');
		var test = false;alert(navigator.onLine);
		var href= jQuery(this).attr('data-href');
		if((navigator && navigator.onLine === false)|| test == true){alert('test2');
			var templateId = jQuery(this).attr('data-offline-template');
			var templateKeyData =jQuery(this).attr('data-offline-key');
			loadLocalPage(href,templateId,templateKeyData);
			return false;
		}else{
			window.location = href;
		}
	});
	jQuery("#filterbutton").live('click',function(e){
		var test = false;
		if((navigator && navigator.onLine === false)|| test == true){
			e.preventDefault();
			var formObj = jQuery(this).parents("form").serializeObject();
			var templateId = formObj['pageName'];
			var resources = getResources();
			var modelName = getModelName(resources, templateId);
			var dataModelObj = getDataModel(modelName);
			var selectionObj = new Object();
			var model = dataModelObj.model;
			var keys = dataModelObj.keys;
			var whereValues = new Array();
			var whereFields = new Array();
			
			for(var i in keys){
				var searchValue = formObj['val_' + keys[i]];
				if(searchValue && searchValue != ''){
					whereValues.push(searchValue);
					whereFields.push(keys[i]);
				}
			}
			selectionObj['whereFields'] = whereFields;
			selectionObj['whereValues'] = whereValues;
			selectionObj['search'] = true;
			
			APP.templates.showPage(resources, templateId, selectionObj);
			
			return false;
		}
		jQuery("#search").val('y');
	});
});
function loadLocalPage(href,templateId,templateKeyData){
	var whereFields = new Array();
	var whereValues = new Array();
	try{
		var keyAry = templateKeyData.split(",");
		for (var i in keyAry) {//get key values from href based on data-offline-key attribute
		   var key = keyAry[i];
		   var val = getURLParameter(href, key);
		   whereFields.push(key);
		   whereValues.push(val);
		}
	}catch(err){
	
	}
	var selectionObj = new Object();
	selectionObj['whereFields'] = whereFields;
	selectionObj['whereValues'] = whereValues;
	selectionObj['href'] = href;
	
	resources = getResources();
	APP.templates.showPage(resources, templateId,selectionObj,function(templateData){
		if(href.indexOf('action_mode') >= 0){
			templateData = setMaintenanceParameters(templateData,href);
			
		}
		return templateData;
	});
}
function setMaintenanceParameters(templateData,href){
		var action_mode = getURLParameter(href, "action_mode");
		templateData.page.action_mode = action_mode;
		templateData.page.work_with = 2;
		return templateData;
	
}
function renderTemplate(){
		var dataObj= data1;
		dataObj.page  = {};
        var html = freemarker.render(html1, dataObj);
        var newDoc = document.open("text/html", "replace");
       newDoc.write(html);
       newDoc.close();   
}
APP.templates = (function () {
	function createTemplateData(model,resultSet){
		var templateData = new Object();
		if(localStorage){
			var pageStr = localStorage.getItem(PAGE_MODEL + '-' + model);
			templateData.page = jQuery.parseJSON(pageStr);
			templateData.table_rows = resultSet;
			templateData.disabled= function(name){
				return "";
			}
			if(Object.prototype.toString.call( resultSet ) === '[object Array]' ){
				templateData.row = resultSet[0];
			}else{
				templateData.row = resultSet;
				var dtaAry = new Array();
				dtaAry.push(resultSet);
				templateData.table_rows = dtaAry;
			}
		}
		return templateData;
	}
	function showPage(resources, templateId, selectionObj, addAdditionalData){
		var templates = resources.mobileTemplates;
		var homeTemplateObj = templates[templateId];
		var model = homeTemplateObj.dataStore;
		model = model.replace(".","_");
		function selectSuccessCallback(results){
			results = getCrossDBResults(results);
			var templateData = createTemplateData(model,results);
			templateData.page.pageName = templateId;//set the template being used
			if(addAdditionalData){
				templateData = addAdditionalData(templateData);
				
			}
			history[history.length] = jQuery("body").html();
			var html = freemarker.render(homeHtml, templateData);
			jQuery("body").html(html);
			
			//after adding page content to body, if its a maintainer form - set the disabled key fields
			var mode = templateData.page.action_mode;
			if((selectionObj && selectionObj.whereFields.length > 0 ) && (mode == 'update' || mode == 'delete')){//for maintenance actions
				for(var i in selectionObj.whereFields){
					jQuery("#" + selectionObj.whereFields[i]).prop("readonly",true);
				}
			}
			refreshEvents();
		}
		
		var homeHtml = homeTemplateObj.html;
		try{//for adding a new record
			var action_mode = getURLParameter(selectionObj.href, "action_mode");
			if(action_mode && action_mode == 'add'){
				selectSuccessCallback();
				return
			}
		}catch(err){
		
		}
		var dataModelObj = getDataModel(model);
		if(!selectionObj || selectionObj.whereFields.length == 0){
			APP.database.selectAll(dataModelObj,selectSuccessCallback);
		}else if(selectionObj && selectionObj.search == true){
			APP.database.selectForSearch(model,selectionObj,selectSuccessCallback);
		}else{
			APP.database.selectOne(model,selectionObj.whereFields, selectionObj.whereValues,selectSuccessCallback);
		}
	}
	function showHome(resources){
		var startPage = resources.startPage;
		showPage(resources, startPage);
	}
	function getCrossDBResults(results){
		var newArray = new Array();
		if(results === undefined){
			results = new Object();
			return results;
		}
		if(APP.database.type == 'websql'){
			if(Object.prototype.toString.call( results ) === '[object Array]'){
				for(var i in results){
					var row = results[i]['ROWDATA'];
					row = jQuery.parseJSON(row);
					newArray.push(row);
				}
				return newArray;
			}else{
				var row = results['ROWDATA'];
				row = jQuery.parseJSON(row);
				return row;
			}
		}
		return results;
	}
return {
        showHome: showHome,
		 showPage: showPage
    };
}());



function getURLParameter(href, name) {
    return decodeURIComponent(
        (RegExp(name + '=' + '(.+?)(&|$)').exec(href)||[,null])[1]
    );
}
