/*
2014 michaels ross and cole ltd
This demo has been adapted from code made available by FTLabs. Attribution below:
Copyright (C) 2013 The Financial Times Ltd.
*/
APP.applicationController = (function () {
    'use strict';
 
    var fastClick;
 
    function offlineWarning() {
        alert("This feature is only available online.");
    }
 
    function pageNotFound() {
        alert("That page you were looking for cannot be found.");
    }
	function synchronizeData(dictionary, appName){
		
	}
    function showHome(resources){
		
        $("#body").html(APP.templates.showHome(resources));
 
        // Load up the last cached copy of the news
        //APP.articlesController.showArticleList();
 
        $('#refreshButton').click(function () {
 
            // If the user is offline, don't bother trying to synchronize
            if (navigator && navigator.onLine === false) {
                offlineWarning();
            } else {
                APP.articlesController.synchronizeWithServer(function failureCallback() {
                    alert("This feature is not available offline");
                });
            }
        });
    }
 
    function showArticle(id) {
        $("#body").html(APP.templates.articleLoading());
        APP.articlesController.showArticle(id);
    }
 
	function initialize(data,resources){
		if(data === undefined){
			return;
		}
		var model = data.model.model;
		var modelStr = JSON.stringify(data.model);
		
		var pageModelStr = JSON.stringify(data.page);
		APP.database.deleteAllFrom(model,function(output1){
			APP.database.insertInto(data,function(output2){
				//APP.database.selectOne(model,["mrc_id"],["100001"],function(results){
				//	var a = results;
				//});
				if(localStorage){
					var key = DATA_MODEL + '-' + model;
					localStorage.setItem(key,modelStr);
					key = PAGE_MODEL + '-' + model;
					localStorage.setItem(key,pageModelStr);
				}
				
			});
		});
	}

    function start(resources) { 
		$("head").append("<style>" + resources.css + "</style>");

		//$("body").html(APP.templates.application());

		$("#loading").remove();
		
		initializeDB(resources);
      
		var storeResources = true;
        if (storeResources && window['localStorage']) {
            localStorage.resources = JSON.stringify(resources);
        }
    }
	function checkDBReady(resources){
		if(APP.database){
			//showHome(resources);
		}else{
			setTimeout(function(){checkDBReady(resources)},50);
		}
	}
	function refreshLocalDB(resources){
		function callDataStore(stores,idx){
			var url = stores[idx];
			function sendNewDataToServer(dataStore,successCallback){
				var app = dataStore;
				dataStore = dataStore.replace(".","_");
				var dataModelObj = getDataModel(dataStore);
				if(dataModelObj){
					APP.database.getAuditData(dataModelObj,function(results){
						var updateAry = new Array();
						var addAry = new Array();
						var deleteAry = new Array();
						if(!results || results.length == 0){
							successCallback();
							return;
						}
						for(var i in results){
							if(results[i].audit_action == 'add'){
								addAry.push(results[i]);
							}else if(results[i].audit_action == 'update'){
								updateAry.push(results[i]);
							}else if(results[i].audit_action == 'delete'){
								deleteAry.push(results[i]);
							}
						}
						if(addAry.length >0){
							var jsonStr = JSON.stringify(addAry);
							app +="?one_step=1&action_mode=add&datasync=1&data=" + jsonStr + "&x=" + Math.random();
							jQuery.post(app,doUpdate);
						}else{
							doUpdate();
						}
						function doUpdate(){
							if(updateAry.length >0){
								var jsonStr = JSON.stringify(updateAry);
								app +="?one_step=1&action_mode=update&datasync=1&data=" + jsonStr + "&x=" + Math.random();
								jQuery.post(app,doDelete);
							}else{
								doDelete();
							}
						}
						function doDelete(){
							if(deleteAry.length >0){
								var jsonStr = JSON.stringify(deleteAry);
								app +="?one_step=1&action_mode=delete&datasync=1&data=" + jsonStr + "&x=" + Math.random();
								jQuery.post(app,successCallback);
							}else{
								cleanupAudit();
							}
						}
						function cleanupAudit(){
							APP.database.deleteAudit(dataModelObj.model,function(results){
								successCallback();
							});
						}
						
						
					});
				}else{
					successCallback();
				}
				
			}
			sendNewDataToServer(url,function(){
				//APP.applicationController.startDataStore(null,resources);    
				//		checkDBReady(resources);
				jQuery.ajax({
					url: SERVLET_PATH + url + '?init=1&mobiledata=1&x=' + Math.random(),
					success: function(data){
						APP.applicationController.startDataStore(data,resources);    
						idx++;
						if(idx < stores.length){
							callDataStore(stores,idx);
						}else{
							checkDBReady(resources);
						}
					},
					error: function(){
						APP.applicationController.startDataStore(null,resources);    
						checkDBReady(resources);
					}
				});
			});
		}
		var stores = resources.dataStores;
		if(stores.length != 0){
			callDataStore(stores,0);
		}
	}
	function initializeDB(resources){
		APP.indexedDB.start(function indexedDBSuccess() {
            APP.database = APP.indexedDB;
			refreshLocalDB(resources)
            // When indexedDB is not available, fallback to trying websql
        }, function indexedDBFailure() {
            APP.webSQL.start(function webSQLSuccess() {
                APP.database = APP.webSQL;
				refreshLocalDB(resources)
            // When webSQL not available, fall back to using the network
            }, function webSQLFailure() {
               alert('WEBSQL and INDEXEDDB Not Supported');
            });
        });
	}
	function startDataStore(data,resources){
		APP.database.install(data,function dbSuccess() {
			if(data !== null){
				initialize(data,resources);
			}
		}, function dbFailure() {
		
		});
		
	}
	
    return {
        start: start,
		startDataStore: startDataStore
    };
}());