/*
2014 michaels ross and cole ltd
This demo has been adapted from code made available by FTLabs. Attribution below:
Copyright (C) 2013 The Financial Times Ltd.
*/
/********Handle WebSQL and IndexedDB Support **************/
var AUDIT_TABLE_SUFFIX = "_audit";
APP.webSQL = (function () {
    'use strict';
 
    var smallDatabase;
	var websql = this;
    function runQuery(query, data, returnFirst, successCallback) {
        var i, l, remaining;
 
 
        if (!(data[0] instanceof Array)) {
            data = [data];
        }
 
        remaining = data.length;
 
        function innerSuccessCallback(tx, rs) {
            var i, l, output = [];
            remaining = remaining - 1;
            if (!remaining) {
 
                // HACK Convert row object to an array to make our lives easier
                for (i = 0, l = rs.rows.length; i < l; i = i + 1) {
                    output.push(rs.rows.item(i));
                }
                if (successCallback) {
                    successCallback(returnFirst ? output[0] : output);
                }
            }
        }
 
        function errorCallback(tx, e) {
            if (console) {
          console.log("WebSQL error: ", tx, e);
        }
        }
 
        smallDatabase.transaction(function (tx) {
            for (i = 0, l = data.length; i < l; i = i + 1) {
                tx.executeSql(query, data[i], innerSuccessCallback, errorCallback);
            }
        });
    }
	function  start( successCallback, failureCallback){
		 try {
            smallDatabase = openDatabase("APP", "1.0", "mrc webapp", (5 * 1024 * 1024));
        } catch (e) {
            if (failureCallback){
                failureCallback();
				return;
            }
        }
		successCallback();
		return;
	}
	 function install(data, successCallback, failureCallback) {
        try {
           // smallDatabase = openDatabase("APP", "1.0", "mrc webapp", (5 * 1024 * 1024));
			if(data !== null){
				var modelObj = data.model;
				var keys = modelObj.keys;
				var model = modelObj.model;
				var types = modelObj.fieldTypes;
				var sql = getCreateStatement(modelObj);
				runQuery(sql, [], false, successCallback);
				sql = getCreateAuditStatement(keys,model); //create audit table
				runQuery(sql, [], false, function(){});
				return;
			}
        } catch (e) {
            if (failureCallback){
                failureCallback();
				return;
            }
        }
		successCallback();
    }
	function doAudit(model,keyValue,action){
		model = model + AUDIT_TABLE_SUFFIX;
		APP.webSQL.selectOne(model, ['mrc_id'], [keyValue], function(result){
			if(!result){//add new audit record
				var sql = getInsertIntoStatement(["mrc_id"],model);
				var dataAry = new Array();
				dataAry.push(keyValue);
				dataAry.push(action);
				var insertData  = new Array();
				insertData[0] = dataAry;
				runQuery(sql, insertData, false, function(){});
			}else{//update audit record
				var sql = getUpdateStatement(model);
				var dataAry = new Array();
				dataAry.push(action);
				dataAry.push(keyValue);
				var updateData  = new Array();
				updateData[0] = dataAry;
				runQuery(sql, updateData, false, function(){});
			}
		});
		
	}
	function getAuditData(model,returnDataCallback){
		var auditModel = model.model + AUDIT_TABLE_SUFFIX;
		var sql = "SELECT * FROM " + auditModel;
		 runQuery(sql, [], false, function(auditResults){
			if(!auditResults){
				returnDataCallback();
				return false;
			}
			var sql = "SELECT * FROM " + model.model + " WHERE mrc_id";
			var dataAry = new Array();
			if(Object.prototype.toString.call( auditResults ) === '[object Array]'){
				 sql+= " IN(";
				
				for(var i in auditResults){
					if(i > 0){
						sql+= ","
					}
					sql+= "?"
					dataAry.push(auditResults[i]['mrc_id']);
				}
				sql += ");"
				
			}else{
				 sql+= "=?";
				 dataAry.push(auditResults['mrc_id']);
			}
			function addAuditInfo(modelResultSet){
				for(var i in modelResultSet){
					var id = modelResultSet[i]['mrc_id'];
					var auditAction;
					for(var j in auditResults){
						var auditId = auditResults[j]['mrc_id'];
						if(auditId == id){
							auditAction = auditResults[j]['ROWDATA'];
							break;
						}
					}	
					modelResultSet[i]['audit_action'] = auditAction;
					
				}
				returnDataCallback(modelResultSet);
			}
			runQuery(sql, dataAry, false, addAuditInfo);
		 });
	}
	function deleteAudit(model, successCallback){
		var sql = "DELETE FROM " + model + AUDIT_TABLE_SUFFIX
		var dataAry = new Array();
        runQuery(sql, dataAry, false, successCallback);
	}
	function insertOne(dataModelObj,dbDataObj, successCallback){
		var keys = dataModelObj.keys;
		var row = dbDataObj;
		var model = dataModelObj.model;
		var remaining = row.length, i, l, insertData = [];
        if (remaining === 0) {
            successCallback();
        }
 
        // Convert article array of objects to array of arrays
		var sql = getInsertIntoStatement(keys,model);
		var dataAry = new Array();
		var rowStr = JSON.stringify(row);
		var keyValue = "";
		for(var j in keys){
			if(j > 0){
				keyValue += MULTI_KEY_DELIMIT;
			}
			keyValue += row[keys[j]];
		}
		dataAry.push(keyValue);
		for(var j in keys){
				dataAry.push(row[keys[j]]);
			}
		dataAry.push(rowStr);
		insertData[0] = dataAry;
        runQuery(sql, insertData, false, successCallback);
		doAudit(model, keyValue, "add");
	}
	function updateOne(dataModelObj,dbDataObj, successCallback){
		var keys = dataModelObj.keys;
		var row = dbDataObj;
		var model = dataModelObj.model;
		var remaining = row.length, i, l, updateData = [];
        if (remaining === 0) {
            successCallback();
        }
 
        // Convert article array of objects to array of arrays
		var sql = getUpdateStatement(model);
		
		var dataAry = new Array();
		var rowStr = JSON.stringify(row);
		var keyValue = "";
		for(var j in keys){
			if(j > 0){
				keyValue += MULTI_KEY_DELIMIT;
			}
			keyValue += row[keys[j]];
		}
		selectOne(model, keys, [keyValue], function(result){
			var dbObj = result['ROWDATA']
			dbObj = JSON.parse(dbObj);
			for (var prop in row) {
			  if(row.hasOwnProperty(prop)){
				var val = row[prop];
				if(val !== undefined){
					dbObj[prop] = row[prop];
				}
			  }
		   }
		   var rowStr = JSON.stringify(dbObj);
		   dataAry.push(rowStr);
			dataAry.push(keyValue);
			updateData[0] = dataAry;
			runQuery(sql, updateData, false, successCallback);
			doAudit(model, keyValue, "update");
		});
		
	}
	function deleteOne(dataModelObj,dbDataObj, successCallback){
		var keys = dataModelObj.keys;
		var row = dbDataObj;
		var model = dataModelObj.model;
		var remaining = row.length, i, l, updateData = [];
        if (remaining === 0) {
            successCallback();
        }
 
        // Convert article array of objects to array of arrays
		var sql = getDeleteStatement(model);
		var dataAry = new Array();
		var keyValue = "";
		for(var j in keys){
			if(j > 0){
				keyValue += MULTI_KEY_DELIMIT;
			}
			keyValue += row[keys[j]];
		}
		dataAry.push(keyValue);
		updateData[0] = dataAry;
        runQuery(sql, updateData, false, successCallback);
		doAudit(model, keyValue, "delete");
	}
    function insertInto(dataObj, successCallback) {
		var keys = dataObj.model.keys;
		var rows = dataObj.table_rows;
		var model = dataObj.model.model;
		var remaining = rows.length, i, l, insertData = [];
        if (remaining === 0) {
            successCallback();
        }
 
        // Convert article array of objects to array of arrays
		var sql = getInsertIntoStatement(keys,model);
        for (i = 0, l = rows.length; i < l; i = i + 1) {
			var dataAry = new Array();
			var row = rows[i];
			var rowStr = JSON.stringify(row);
			var keyValue = "";
			for(var j in keys){
				if(j > 0){
					keyValue += MULTI_KEY_DELIMIT;
				}
				keyValue += rows[i][keys[j]];
			}
			dataAry.push(keyValue);
			for(var j in keys){
				if(keys[j] != 'mrc_id'){
					dataAry.push(row[keys[j]]);
				}
			}
			dataAry.push(rowStr);
            insertData[i] = dataAry;
        }
        runQuery(sql, insertData, false, successCallback);
        
    }
 
    function deleteAllFrom(model, successCallback) {
        runQuery("DELETE FROM " + model, [], false, successCallback);
    }
 
    function selectAll(modelObj, successCallback) {
		
		var sql = getSelectAllStatement(modelObj);
       
        runQuery(sql, [], false, successCallback);
        
    }
	function selectMaxValue(modelObj, successCallback) {
		
		var sql = getSelectMaxStatement(modelObj);
       
        runQuery(sql, [], false, successCallback);
        
    }
    function selectOne(model, whereFields, whereValues, successCallback) {
		var sql = getSelectWhereStatement(model,whereFields);
		var id = "";
		for(var j in whereValues){
			if(j > 0){
				id += MULTI_KEY_DELIMIT;
			}
			id += whereValues[j];
		}
         runQuery(sql, [id], true, successCallback);
        
    }
	 function selectForSearch(model,selectionObj,successCallback) {
		
		var sql = getSelectWhereSearchStatement(model,selectionObj.whereFields);
         runQuery(sql, selectionObj.whereValues, true, successCallback);
        
    }
	function getUpdateStatement(model){
		var sql = "UPDATE " + model + " SET ROWDATA=? WHERE mrc_id=?";
		return sql;
	}
	function getDeleteStatement(model){
		var sql = "DELETE FROM " + model + " WHERE mrc_id=?";
		return sql;
	}
	function getInsertIntoStatement(keys,model){
		var sql = "INSERT INTO " + model + " (";
		var fieldStr = 'mrc_id, ';
		for(var i in keys){
			if(keys[i] != 'mrc_id'){
				fieldStr += keys[i] + ',';
			}
		}
		fieldStr += ' ROWDATA';
		var valueStr = '?,';
		for(var i in keys){
			if(keys[i] != 'mrc_id'){
				valueStr += '?,';
			}
		}
		valueStr += '?'
		sql += fieldStr + ") values(" + valueStr + ");";
		return sql;
	}
	function getCreateStatement(modelObj){
		var model = modelObj.model;
		var keys = modelObj.keys;
		var fields = modelObj.fields;
		var sql = "CREATE TABLE IF NOT EXISTS " + model + "(";
		var fieldStr = 'mrc_id TEXT,';
		for(var i in keys){
			var x = fields.indexOf(keys[i]);
			var type = modelObj.fieldTypes[x];
			fieldStr += keys[i] + ' ' + type + ',';
		}
		fieldStr += ' ROWDATA TEXT';
		sql += fieldStr + ");";
		return sql;
	}
	function getCreateAuditStatement(keys,model){
		var sql = "CREATE TABLE IF NOT EXISTS " + model + AUDIT_TABLE_SUFFIX + "(";
		var fieldStr = 'mrc_id TEXT,';
		
		fieldStr += ' ROWDATA TEXT';
		sql += fieldStr + ");";
		return sql;
	}
	function getSelectAllStatement(modelObj){
		var model = modelObj.model;
		var orderBy = modelObj.sort;
		
		var sql = "SELECT * FROM " +model;
		for(var i in orderBy){
			if(i > 0){
				sql += ', ';
			}
			sql += ' ORDER BY ' + orderBy[i];
		}
		return sql;
	}
	function getSelectMaxStatement(modelObj){
		var model = modelObj.model;
		var orderBy = modelObj.sort;
		var sql = "SELECT MAX(" + modelObj.keys[0] + ") FROM " +model;
		
		return sql;
	}
	function getSelectWhereStatement(model,whereFields){
		var sql = "SELECT * FROM  " + model + " WHERE mrc_id=?";
		return sql;
	}
	function getSelectWhereSearchStatement(model,whereFields){
		var sql = "SELECT * FROM  " + model + " WHERE ";
			for(var i in whereFields){
				if(i > 0){
					sql += ' AND ';
				}
				sql += whereFields[i] + '=?';
			}
		return sql;
	}
    return {
        start: start,
		install:install,
        insertInto: insertInto,
        deleteAllFrom: deleteAllFrom,
        selectAll: selectAll,
        selectOne: selectOne,
		insertOne:insertOne,
		updateOne:updateOne,
		deleteOne:deleteOne,
		selectForSearch:selectForSearch,
		selectMaxValue:selectMaxValue,
		getAuditData:getAuditData,
		deleteAudit:deleteAudit,
		type:'websql'
    };
}());